<#ibiztemplate>
TARGET=PSSYSSERVICEAPI
</#ibiztemplate>
<?xml version="1.0" encoding="UTF-8"?>
<project xmlns="http://maven.apache.org/POM/4.0.0"
         xmlns:xsi="http://www.w3.org/2001/XMLSchema-instance"
         xsi:schemaLocation="http://maven.apache.org/POM/4.0.0 http://maven.apache.org/xsd/maven-4.0.0.xsd">
    <modelVersion>4.0.0</modelVersion>
    <parent>
        <artifactId>${pub.getCodeName()?lower_case}-provider</artifactId>
        <groupId>${pub.getPKGCodeName()?lower_case}</groupId>
        <version>${pub.getVersionString()?default("V0.0.1_alpha")}</version>
    </parent>

    <artifactId>${pub.getCodeName()?lower_case}-provider-${api.getCodeName()?lower_case}</artifactId>
    <name>${pub.getCodeName()?lower_case?cap_first} Microservice ${api.getCodeName()}</name>
    <description>${pub.getMemo()?default(pub.getName())} ${api.getName()}</description>

    <dependencies>
        <dependency>
            <groupId>${pub.getPKGCodeName()?lower_case}</groupId>
            <artifactId>${pub.getCodeName()?lower_case}-core</artifactId>
            <version>${r'${project.version}'}</version>
        </dependency>
    </dependencies>

<#if pub.getPSDeployCenter()?? && pub.getPSDeployCenter().getPSRegistryRepo()??>
    <properties>
        <docker.image.prefix>${pub.getPSDeployCenter().getPSRegistryRepo().getConnStr()}</docker.image.prefix>
    </properties>
</#if>

    <profiles>
        <profile>
            <id>${item.codeName?lower_case}</id>
            <build>
                <resources>
                    <resource>
                        <directory>${r'${basedir}'}/src/main/resources</directory>
                        <includes>
                            <include>**/**</include>
                        </includes>
                    </resource>
                </resources>

                <plugins>
                    <plugin>
                        <groupId>org.springframework.boot</groupId>
                        <artifactId>spring-boot-maven-plugin</artifactId>
                        <configuration>
                            <finalName>${pub.getCodeName()?lower_case}-provider-${item.codeName?lower_case}</finalName>
                            <jvmArguments>-Dfile.encoding=UTF-8</jvmArguments>
                            <mainClass>${pub.getPKGCodeName()}.${item.codeName?lower_case}.${sys.codeName}${item.codeName}Application</mainClass>
                            <outputDirectory>../../</outputDirectory>
                        </configuration>
                        <executions>
                            <execution>
                                <goals>
                                    <goal>repackage</goal>
                                </goals>
                            </execution>
                        </executions>
                    </plugin>

<#if pub.getPSDeployCenter()?? && pub.getPSDeployCenter().getPSRegistryRepo()??>                    
                    <plugin>
                            <groupId>com.spotify</groupId>
                            <artifactId>docker-maven-plugin</artifactId>
                            <version>0.4.13</version>
                            <configuration>
                            <serverId>ibiz-dev</serverId>
                            <imageName>${r'${docker.image.prefix}/${project.artifactId}'}:latest</imageName>
                            <dockerDirectory>${r'${project.basedir}'}/src/main/docker</dockerDirectory>
                            <resources>
                                <resource>
                                    <targetPath>/</targetPath>
                                    <directory>../../</directory>
                                    <include>${r'${project.artifactId}'}.jar</include>
                                </resource>
                            </resources>
                            </configuration>
                    </plugin>                    
</#if>                        
                </plugins>
            </build>
        </profile>
    </profiles>

</project>
